# coding: utf-8

from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from requests.exceptions import (
    HTTPError,
    ReadTimeout,
)


def retry_http_errors(service_name):
    """
    Хелпер для функции определеющей необходимость ретрая при ошибках HTTP запросов.
    >> @retry(retry_on_exception=retry_http_errors('some_service_name'))
    :param service_name: имя сервиса (нужно только для логирования)
    """
    def retry_if_retriable_error(exception):
        """Return True if we should retry, False otherwise"""

        bad_statuses = (
            423,  # Locked
            429,  # Too many requests
        )

        if isinstance(exception, HTTPError):
            if exception.response is not None:
                status_code = getattr(exception.response, 'status_code', 0)
                if status_code in bad_statuses or status_code >= 500:
                    with log.fields(url=exception.request.url, status_code=status_code, service_name=service_name):
                        log.error('Retrying request.')
                    return True
        if isinstance(exception, ReadTimeout):
            with log.fields(url=exception.request.url, service_name=service_name):
                log.error('Retrying on read timeout')
            return True
        return False
    return retry_if_retriable_error
