# coding: utf-8

import os
from threading import RLock
from urllib.parse import (
    urlparse,
    urlunparse,
)

from flask import request
from cachetools import TTLCache, cached

from intranet.yandex_directory.src.yandex_directory.core.utils import (
    objects_map_by_id,
)

if os.environ.get('ENVIRONMENT') == 'autotests':
    import sys
    services_cache_size = 0  # для тестов размер кэша == 0
    # установим бесконечное время жизни,
    # чтобы TTLCache не пытался вызвать expire
    # на ключ all-services через 300с
    services_cache_ttl = sys.maxsize
else:
    services_cache_size = 1000
    services_cache_ttl = 300  # 5 минут

services_cache = TTLCache(
    maxsize=services_cache_size,
    ttl=services_cache_ttl,
)
services_lock = RLock()


@cached(cache=services_cache,
        key=lambda *args, **kwargs: 'all-services',
        lock=services_lock)
def get_services(meta_connection, fields=None):
    """Возвращает словарь сервисов, известных Директории.

    Результат кэшируется на 5 минут.
    """
    from intranet.yandex_directory.src.yandex_directory.core.models import (
        ServiceModel,
    )

    # Подгрузим объекты сервисов из метабазы
    services = ServiceModel(meta_connection).find(fields=fields)
    # Сделаем словарь, чтобы адресовать сервисы по id
    services = objects_map_by_id(services)
    return services


def x_host_for_service(slug):
    # связано с CACHE_KEY_HEADER_RE
    header = 'x-{}-service-host'.format(
        slug.replace('_', '-')
    )
    return request.headers.get(header)

def try_replace_url_host(url, host):
    """
    Для относительных путей ведем нужный host
    :param services: сервис
    """

    try:
        parsed = list(urlparse(url))
        parsed[1] = host.strip()
        return urlunparse(parsed)
    except Exception:
        return url
