# -*- coding: utf-8 -*-

from datetime import timedelta
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    utcnow,
    format_date,
)


def get_promocode_expires_at(promocode):
    if promocode['valid_for']:
        # если явно указан срок действия игнорируем запись expires_at
        expires_at = format_date(utcnow() + timedelta(days=promocode['valid_for']), only_date=True)
    else:
        expires_at = promocode['expires_at']
    return expires_at


def format_promocode(main_connection, promocode, org_id):
    return {
        'id': promocode['id'],
        'expires': get_promocode_expires_at(promocode),
        'description': get_description_for_promocode(main_connection, promocode, org_id),
    }


def get_description_for_promocode(main_connection, promocode, org_id):
    """Возвращает описание промокода на языке организации или на английском, если нужного не нашлось"""
    from intranet.yandex_directory.src.yandex_directory.core.utils.organization import get_organization_language

    language = get_organization_language(main_connection, org_id=org_id)
    promocode_description = promocode['description'].get(language)

    # если на выбранном организацией языке не нашли - возвращаем описание на английском
    if not promocode_description:
        promocode_description = promocode['description']['en']

    return promocode_description
