# coding: utf-8

def mark_user_restored(meta_connection, main_connection,
            user_id,
            org_id,
            department_id):
    """ Восстанавливаем сотрудника в организации.
    """
    from intranet.yandex_directory.src.yandex_directory.core.models.user import (
        UserDismissedModel,
        UserModel,
        UserMetaModel,
    )
    from intranet.yandex_directory.src.yandex_directory.core.tasks import SyncExternalIDS
    from intranet.yandex_directory.src.yandex_directory.core.task_queue.exceptions import DuplicatedTask

    user_model = UserModel(main_connection)
    filter_data = {
        'org_id': org_id,
        'id': user_id,
        'is_dismissed': True,
    }
    user_model.update_one(
        dict(department_id=department_id, is_dismissed=False),
        filter_data)
    UserDismissedModel(main_connection).delete(
        {
            'org_id': org_id,
            'user_id': user_id,
        }
    )
    user_meta_model = UserMetaModel(meta_connection)
    user_meta_model.filter(org_id=org_id, id=user_id).update(is_dismissed=False)

    try:
        SyncExternalIDS(main_connection).delay(
            org_id=org_id,
            user_id=user_id,
        )
    except DuplicatedTask:
        pass


def restore_user(
        meta_connection, main_connection,
        uid,
        org_id,
        department_id,
        author_id=None):
    """Восстанавливаем уволенного пользователя, генерим событие
    """
    from intranet.yandex_directory.src.yandex_directory.core.models import UserModel
    from intranet.yandex_directory.src.yandex_directory.core.actions import action_user_add

    if not author_id:
        author_id = uid

    mark_user_restored(
        meta_connection, main_connection,
        user_id=uid,
        org_id=org_id,
        department_id=department_id
    )
    # Надо получить пользователя с департаментом, чтобы передать его в событие,
    # чтобы обновился счетчик количества пользователей в отделе
    user = UserModel(main_connection).get(
        user_id=uid,
        org_id=org_id,
        fields=[
            '*',
            'department.*',
        ]
    )
    action_user_add(
        main_connection,
        org_id=org_id,
        author_id=author_id,
        object_value=user
    )
    return user
