import os
import threading
import uuid


class YcridManager(object):
    thread_local = None

    def __init__(self):
        self.thread_local = threading.local()

    def get(self):
        return getattr(self.thread_local, 'ycrid', ''), getattr(self.thread_local, 'req_id', '')

    def set(self, ycrid):
        if ycrid:
            self.thread_local.ycrid = ycrid
        self.generate()

    def reset(self):
        self.thread_local.ycrid = ''
        self.thread_local.req_id = ''

    def generate(self, suffix='', force=False):
        self.thread_local.req_id = uuid.uuid4().hex
        if suffix:
            suffix += '-'
        if not getattr(self.thread_local, 'ycrid', '') or force:
            self.thread_local.ycrid = 'directory-%s%s-%s' % (
                suffix,
                self.thread_local.req_id,
                os.environ.get('DEPLOY_POD_PERSISTENT_FQDN', '')
            )

    def set_from_request(self, request):
        self.thread_local.ycrid = request.headers.get('Yandex-Cloud-Request-ID', '')
        self.generate()


ycrid_manager = YcridManager()
