# coding: utf-8

from flask import request, g

from intranet.yandex_directory.src.yandex_directory.auth.scopes import scope
from intranet.yandex_directory.src.yandex_directory.core.views.base import View
from intranet.yandex_directory.src.yandex_directory.core.utils import prepare_action
from intranet.yandex_directory.src.yandex_directory.core.models.action import ActionModel


from intranet.yandex_directory.src.yandex_directory.common.utils import (
    json_response,
    build_list_response,
)
from intranet.yandex_directory.src.yandex_directory.auth.decorators import (
    internal,
    permission_required,
    requires,
    scopes_required,
)
from intranet.yandex_directory.src.yandex_directory.core.permission.permissions import (
    organization_permissions,
)


class ActionListView(View):
    @internal
    @requires(org_id=True, user=False)
    @scopes_required([scope.read_actions])
    @permission_required([organization_permissions.edit])
    def get(self, meta_connection, main_connection):
        """
        Действия над объектами

        Эта ручка выдает список действий надо объектами организации.
        Поддерживаются фильтры по object_type и object_id.
        Если фильтры не указаны, то будут выдаваться все события.

        Порядок сортировки: от более новых к более старым.
---
tags:
  - Действия
parameters:
      - in: query
        name: object_type
        type: string
        description: тип объектов, для которых нужно выдать действие. Это может быть user, department, group.
      - in: query
        name: object_id
        type: integer
        description: id объекта для которого запрашивается история
      - in: query
        name: page
        type: integer
        description: текущая страница
      - in: query
        name: per_page
        type: integer
        description: какое кол-во объектов выведено на странице
responses:
  200:
    description: Список действий

  403:
    description: {permissions}

        """
        response = build_list_response(
            model=ActionModel(main_connection),
            model_filters=self._get_filters(),
            path=request.path,
            query_params=request.args.to_dict(),
            prepare_result_item_func=prepare_action
        )
        return json_response(
            response['data'],
            headers=response['headers'],
        )

    def _get_filters(self):
        filters = {
            'org_id': g.org_id
        }

        def process_parameter(name):
            value = request.args.get(name)
            if value:
                filters[name] = value

        process_parameter('object_type')
        process_parameter('object_id')
        return filters
