from intranet.yandex_directory.src.yandex_directory.core.views.base import View
from intranet.yandex_directory.src.yandex_directory.auth import decorators as auth_decorators
from intranet.yandex_directory.src.yandex_directory.auth.scopes import scope
from intranet.yandex_directory.src.yandex_directory import swagger as schema_decorators
from intranet.yandex_directory.src.yandex_directory.common.schemas import STRING_OR_NULL
from intranet.yandex_directory.src.yandex_directory.core.models import OrganizationMetaModel
from intranet.yandex_directory.src.yandex_directory.core.cloud.utils import create_or_dismiss_cloud_user
from intranet.yandex_directory.src.yandex_directory.common.utils import json_response
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

EVENT_SCHEMA = {
    'title': 'Event',
    'type': 'object',
    'properties': {
        'event_type': {
            'enum': ['user_added', 'user_removed'],
        },
        'cloud_org_id': STRING_OR_NULL,
        'object_id': STRING_OR_NULL,
    },
    'required': ['event_type', 'object_id', 'cloud_org_id'],
    'additionalProperties': False,
}


class CloudEventHandleView(View):
    @auth_decorators.internal
    @auth_decorators.no_permission_required
    @schema_decorators.uses_schema(EVENT_SCHEMA)
    @auth_decorators.scopes_required([scope.write_users])
    @auth_decorators.requires(org_id=False, user=False)
    def post(self, meta_connection, _, data):
        cloud_org_id = data['cloud_org_id']
        yc_subject = data['object_id']
        log.info('Got event for cloud org %s and subject %s', cloud_org_id, yc_subject)
        create_or_dismiss_cloud_user(yc_subject, cloud_org_id)
        return json_response({}, status_code=201)
