# coding: utf-8
from intranet.yandex_directory.src.yandex_directory.core.views.base import View
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    json_response,
)
from intranet.yandex_directory.src.yandex_directory.auth.decorators import (
    internal,
    no_permission_required,
    no_scopes,
    requires,
)
from intranet.yandex_directory.src.yandex_directory.core.dependencies import (
    get_dependency_slug,
)

# Так как в тестах удобнее мокать глобальные объекты в том
# месте, где они определены, а система модулей в Python
# не такая продвинутая, как в Common Lisp, то тут мы вынуждены
# импортировать модуль dependencies целиком. И уже в нем
# обращаться к атрибуту dependencies
from intranet.yandex_directory.src.yandex_directory.core import dependencies

# from intranet.yandex_directory.src.yandex_directory.auth.scopes import scope


class DependenciesView(View):
    @internal
    @no_permission_required
    @no_scopes
    @requires(user=False, org_id=False)
    def get(self, meta_connection, main_connection):
        """
        Возвращает словарь с описанием зависимостей между сервисами и настройками.

        ---
        tags:
          - Внутренние ручки

        responses:
          200:
            description: Словарь с зависимостями.
        """
        response = dict(
            (
                get_dependency_slug(source),
                list(map(get_dependency_slug, destinations))
            )
            for source, destinations in list(dependencies.dependencies.items())
        )
        return json_response(response)
