# coding: utf-8

from flask import g

from intranet.yandex_directory.src.yandex_directory.common.utils import (
    check_domain_is_correct,
)
from intranet.yandex_directory.src.yandex_directory.core.actions import (
    action_domain_add,
)
from intranet.yandex_directory.src.yandex_directory.core.models.domain import (
    DomainModel,
    WebmasterDomainLogModel,
    domain_action,

)
from intranet.yandex_directory.src.yandex_directory.core.tasks.tasks import (
    SyncSingleDomainTask,
)
from intranet.yandex_directory.src.yandex_directory.core.utils import (
    get_organization_admin_uid,
)
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log
from intranet.yandex_directory.src.yandex_directory.core.task_queue.exceptions import DuplicatedTask


def create_domain_verified_via_webmaster(meta_connection,
                                         main_connection,
                                         domain_name,
                                         org_id,
                                         ):
    # функция мигрирована в доменатор!
    # создаем домен, подтверждаемый через вебмастер
    with log.name_and_fields('domain_verify', org_id=org_id, domain=domain_name):
        log.info('Creating domain verified via webmaster')
        # создаем домен, подтвержденный через вебмастер
        admin_uid = get_organization_admin_uid(main_connection, org_id)
        domain_name = domain_name.lower()

        # проверяем, корректный ли домен
        check_domain_is_correct(
            meta_connection,
            main_connection,
            domain_name,
            admin_uid,
            org_id,
        )

        WebmasterDomainLogModel(main_connection).create(
            org_id=org_id,
            uid=g.user.passport_uid,
            name=domain_name,
            action=domain_action.add
        )

        # в будущем, нужно сюда же передавать и mx, и delegated
        domain_model = DomainModel(main_connection)
        domain = domain_model.create(
            domain_name,
            org_id,
            owned=False,
            via_webmaster=True,
        )

        action_domain_add(
            main_connection,
            org_id=org_id,
            author_id=g.user.passport_uid,
            object_value=domain,
            old_object=None,
        )
        try:
            SyncSingleDomainTask(main_connection).delay(
                org_id=org_id,
                domain_name=domain_name,
            )
        except DuplicatedTask:
            pass
