# coding: utf-8
from functools import wraps

from intranet.yandex_directory.src.yandex_directory.connect_services.idm import get_service
from intranet.yandex_directory.src.yandex_directory.common.exceptions import ServiceNotFound
from intranet.yandex_directory.src.yandex_directory.common.exceptions import UnknownService


def check_service_slug(func):

    @wraps(func)
    def _wrapper(*args, **kwargs):
        service_slug = kwargs['service_slug']
        try:
            kwargs['idm_service'] = get_service(service_slug)
        except ServiceNotFound:
            raise UnknownService(service_slug=service_slug)
        return func(*args, **kwargs)
    return _wrapper


def wrap_with_service_required(view_class):
    from intranet.yandex_directory.src.yandex_directory.setup import view_methods
    for name, method in view_methods(view_class):
        method = check_service_slug(method)
        setattr(view_class, name, method)
