from copy import deepcopy

from intranet.yandex_directory.src.yandex_directory.common.schemas import (
    STRING,
    STRING_OR_NULL,
    INTEGER,
    I18N_STRING,
    INTEGER_OR_NULL,
    LABEL_STRING,
    ORG_NAME_STRING,
    ORG_TYPES_ENUM,
    BOOLEAN,
    DATE_OR_NULL,
    LIST_OF_STRINGS,
)

ADDITIONAL_ORG_FIELDS = {
    # дополнительные поля
    'ogrn': {
        'type': 'string',
    },
    'inn': {
        'type': 'string',
    },
    'admin_id': INTEGER_OR_NULL,
    'trc': {
        'type': 'string',
    },
    'corr_acc': {
        'type': 'string',
    },
    'account': {
        'type': 'string',
    },
    'law_address': {
        'type': 'string',
    },
    'real_address': {
        'type': 'string',
    },
    'head_id': INTEGER_OR_NULL,
    'phone_number': {
        'type': 'string',
    },
    'fax': {
        'type': 'string',
    },
    'email': {
        'type': 'string',
    },
    'revision': INTEGER,
    'source': STRING,
    'tld': STRING,
    'disk_usage': INTEGER,
    'disk_limit': INTEGER,
    'subscription_plan': STRING,
    'shared_contacts': BOOLEAN,
    'maillist_type': {'enum': ['inbox', 'shared', 'both']},
    'has_owned_domains': BOOLEAN,
    'header': {
        'enum': ['connect', 'portal'],
    },
}

CHANGE_OWNER_STATUS_SCHEMA = {
    'title': 'Check status for change owner',
    'type': 'object',
    'properties': {
        'task_id': STRING
    },
    'additionalProperties': False,
    'required': ['task_id']
}

DELETE_ORG_STATUS_SCHEMA = {
    'title': 'Check status for delete organization',
    'type': 'object',
    'properties': {
        'task_id': STRING
    },
    'additionalProperties': False,
    'required': ['task_id']
}

ORGANIZATION_BASE_SCHEMA = {
    'title': 'Organization',
    'type': 'object',
    'properties': {
        'name': ORG_NAME_STRING,
        'language': {
            'enum': ['ru', 'en', 'tr'],
        },
        'country': STRING_OR_NULL,
        'outer_id': INTEGER_OR_NULL,
    },
    'required': ['name', 'language'],
    'additionalProperties': False
}

ORGANIZATION_BASE_SCHEMA['properties'].update(ADDITIONAL_ORG_FIELDS)

ORGANIZATION_OUT_SCHEMA = deepcopy(ORGANIZATION_BASE_SCHEMA)
ORGANIZATION_OUT_SCHEMA['title'] = 'GetOrganization'

# на выдаче мы выдаем или head=None или head с развернутым объектом
# а чисто head не нужен
del ORGANIZATION_OUT_SCHEMA['properties']['head_id']
ORGANIZATION_OUT_SCHEMA['properties']['head'] = {'type': ['object', 'null']}
# id организации read-only
ORGANIZATION_OUT_SCHEMA['properties']['id'] = INTEGER
# label тоже должен быть
ORGANIZATION_OUT_SCHEMA['properties']['label'] = LABEL_STRING
# так же, при выдаче присутствует список доменов
ORGANIZATION_OUT_SCHEMA['properties']['domains'] = {'type': 'object'}
# Внимание! Поле admin_uid Portal использует для того, чтобы ходить в некоторые
#           ручки PDD напрямую
ORGANIZATION_OUT_SCHEMA['properties']['admin_uid'] = INTEGER
# А имя мы сейчас выдаем как localized
ORGANIZATION_OUT_SCHEMA['properties']['name'] = I18N_STRING
ORGANIZATION_OUT_SCHEMA['properties']['services'] = LIST_OF_STRINGS
ORGANIZATION_OUT_SCHEMA['properties']['logo'] = {'type': ['object', 'null']}
ORGANIZATION_OUT_SCHEMA['properties']['partner_id'] = INTEGER_OR_NULL
ORGANIZATION_OUT_SCHEMA['properties']['subscription_plan_expires_at'] = DATE_OR_NULL
ORGANIZATION_OUT_SCHEMA['properties']['organization_type'] = STRING
ORGANIZATION_OUT_SCHEMA['properties']['user_count'] = INTEGER
ORGANIZATION_OUT_SCHEMA['properties']['vip'] = LIST_OF_STRINGS

ORGANIZATION_UPDATE_SCHEMA = deepcopy(ORGANIZATION_BASE_SCHEMA)
ORGANIZATION_UPDATE_SCHEMA['title'] = 'UpdateOrganization'
ORGANIZATION_UPDATE_SCHEMA['properties'].update(
    {
        'display_domain': STRING,
        'master_domain': STRING,
        'default_uid': INTEGER_OR_NULL,
        'can_users_change_password': BOOLEAN,
    }
)
# для PATCH метода у нас нет required полей
del ORGANIZATION_UPDATE_SCHEMA['required']
# не редактируемые поля
del ORGANIZATION_UPDATE_SCHEMA['properties']['revision']
del ORGANIZATION_UPDATE_SCHEMA['properties']['tld']
del ORGANIZATION_UPDATE_SCHEMA['properties']['source']
del ORGANIZATION_UPDATE_SCHEMA['properties']['disk_usage']
del ORGANIZATION_UPDATE_SCHEMA['properties']['disk_limit']
del ORGANIZATION_UPDATE_SCHEMA['properties']['subscription_plan']
ORGANIZATION_UPDATE_SCHEMA['properties']['organization_type'] = ORG_TYPES_ENUM
ORGANIZATION_UPDATE_SCHEMA['properties']['cloud_org_id'] = STRING_OR_NULL

ORGANIZATION_CREATE_SCHEMA = deepcopy(ORGANIZATION_BASE_SCHEMA)
ORGANIZATION_CREATE_SCHEMA['title'] = 'CreateOrganization'
del ORGANIZATION_CREATE_SCHEMA['required']
del ORGANIZATION_CREATE_SCHEMA['properties']['revision']
# При создании организации можно указать пресет,
# определяющий, какие сервисы надо включить.
ORGANIZATION_CREATE_SCHEMA['properties']['preset'] = STRING

ORGANIZATION_WITH_DOMAIN_CREATE_SCHEMA = deepcopy(ORGANIZATION_BASE_SCHEMA)
ORGANIZATION_WITH_DOMAIN_CREATE_SCHEMA['title'] = 'CreateOrganizationWithDomain'
del ORGANIZATION_WITH_DOMAIN_CREATE_SCHEMA['properties']['revision']
# При создании организации можно указать пресет,
# определяющий, какие сервисы надо включить.
ORGANIZATION_WITH_DOMAIN_CREATE_SCHEMA['properties']['preset'] = STRING
ORGANIZATION_WITH_DOMAIN_CREATE_SCHEMA['properties']['domain_name'] = STRING
ORGANIZATION_WITH_DOMAIN_CREATE_SCHEMA['required'] = ['domain_name', 'tld']
ORGANIZATION_WITH_DOMAIN_CREATE_SCHEMA['properties']['service_id'] = INTEGER


ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA = deepcopy(ORGANIZATION_BASE_SCHEMA)
ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA['title'] = 'CreateOrganizationWithoutDomain'
del ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA['properties']['revision']
# При создании организации можно указать пресет,
# определяющий, какие сервисы надо включить.
ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA['properties']['label'] = LABEL_STRING
ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA['properties']['organization_type'] = ORG_TYPES_ENUM
ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA['properties']['preset'] = STRING
ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA['properties']['clouds'] = LIST_OF_STRINGS
ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA['properties']['cloud_org_id'] = STRING_OR_NULL
ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA['properties']['partner_id'] = INTEGER_OR_NULL
del ORGANIZATION_WITHOUT_DOMAIN_CREATE_SCHEMA['required']

ORGANIZATION_META_SAVE_SCHEMA = {
    'title': 'Save meta info for organization',
    'type': 'object',
    'properties': {
        'value': STRING_OR_NULL
    },
    'required': [],
    'additionalProperties': False
}

ORGANIZATION_CHANGE_OWNER_SCHEMA = {
    'title': 'Change organization owner',
    'type': 'object',
    'properties': {
        'login': STRING,
    },
    'required': ['login'],
    'additionalProperties': False
}


# приватные поля организации
# их не светим в выдаче ручек
# смотри метод '_clean_organization'
ORGANIZATION_PRIVATE_FIELDS = [
    'tld',
    'subscription_plan_changed_at',
    'subscription_plan_expires_at',
    'partner_id',
    'billing_info',
    'logo_id',
    'admin_uid',
    'environment',
    'maillist_type',
    'organization_type',
    'preset',
    'name_plain',
    'vip',
    'karma',
    'ip',
]

# исключения для приватных полей в выдаче внутренних ручек
ORGANIZATION_PRIVATE_FIELDS_INTERNAL_EXCLUSIONS = [
    'subscription_plan_expires_at',
    'partner_id',
    'organization_type',
    'vip',
    'billing_info',
]

# Эти поля нигде задать нельзя и поменять тоже,
# поэтому их убираем для v4 API.
# см. метод '_clean_organization'
ORGANIZATION_PRIVATE_FIELDS_V4 = [
    'head',
    'account',
    'real_address',
    'corr_acc',
    'trc',
    'inn',
    'law_address',
    'ogrn',
]


SERVICE_DEFAULT_FIELDS = (
    'services.enabled',
    'services.expires_at',
    'services.ready',
    'services.slug',
    'services.trial_status',
    'services.trial_expires',
    'services.user_limit',
)

# Здесь явно перечисляем поля, чтобы новые поля, которые
# мы добавляем, не появлялись автоматически в старой версии API
V1_ORGANIZATION_FIELDS = [
    'id',
    'label',
    'name',
    'admin_uid',
    'ogrn',
    'inn',
    'trc',
    'corr_acc',
    'account',
    'law_address',
    'real_address',
    'head_id',
    'phone_number',
    'fax',
    'email',
    'language',
    'header',
    'tld',
    'country',
    'disk_usage',
    'disk_limit',
    'subscription_plan',
    'subscription_plan_changed_at',
    'subscription_plan_expires_at',
    'partner_id',
    'billing_info',
    'logo_id',
    'shared_contacts',
    'environment',
    'maillist_type',
    'organization_type',
    'preset',
    'name_plain',
    'user_count',
    'vip',
    # не из базы
    'revision.*',
    'head.*',
    'services.*',
    'domains.*',
    'logo.*',
    'admin_id',
    'has_owned_domains',
    # Так как у вложенных полей через ** prefetch_related
    # не раскрывается, то services.slug надо указать явно
    'services.slug',
]
