# coding: utf-8
from intranet.yandex_directory.src.yandex_directory.auth.decorators import internal, no_scopes, no_permission_required, requires
from intranet.yandex_directory.src.yandex_directory.connect_services.roles import get_service_roles
from intranet.yandex_directory.src.yandex_directory.core.views.base import View
from intranet.yandex_directory.src.yandex_directory.common.utils import json_response
from flask import request


class RolesListView(View):

    @internal
    @no_permission_required
    @no_scopes
    @requires(org_id=False, user=False)
    def get(self, meta_connection, main_connection, service_slug):
        """
        Список прав сервиса

        Пример ответа:

            {
                'data': [
                     {
                        'slug': 'edit_without_rights_monetization',
                        'name': {
                            'ru': 'Ограниченное редактирование с монетизацией',
                            'en': 'Restricted editing with monetization',
                        },
                    },
                    {
                        'slug': 'edit_without_rights',
                        'name': {
                            'ru': 'Ограниченное редактирование',
                            'en': 'Restricted editing',
                        }
                    },
                    {
                        'slug': 'edit',
                        'name': {
                            'ru': 'Редактирование',
                            'en': 'Editing',
                        },
                    },
                    {
                        'slug': 'read',
                        'name': {
                            'ru': 'Просмотр',
                            'en': 'Read',
                        },
                    },
                    {
                        'slug': 'read_monetization',
                        'name': {
                            'ru': 'Просмотр с монетизацией',
                            'en': 'Read with monetization',
                        },
                    },
                ]
            }

        ---
        tags:
          - Внутренние ручки
        parameters:
          - in: path
            name: service_slug
            required: true
            type: string
          - in: query
            name: resource_id
            required: false
            type: integer
        responses:
          200:
            description: Словарь прав внутри сервиса.
          422:
            description: Не указаны необходимые праметры.
        """

        result = get_service_roles(service_slug.lower(), **request.args.to_dict())

        return json_response({
            'data': result,
        })
