# -*- coding: utf-8 -*-


class YarmError(Exception):
    def __init__(self, message, *args):
        self.message = message
        super(YarmError, self).__init__(*args)


class YarmLoginError(YarmError):
    pass


class YarmConnectionError(YarmError):
    pass


class YarmDuplicateError(YarmError):
    pass


class YarmRateControlError(YarmError):
    pass


error_reason_to_exception = {
    'login error': YarmLoginError,
    'connect error': YarmConnectionError,
    'dublicate error': YarmDuplicateError,
    'rate control error': YarmRateControlError,
}
