# coding: utf-8

from tools_structured_logs.helpers.requests.session_object.instrumenter import SessionObjectInstrumenter

from intranet.yandex_directory.src.yandex_directory.common.extensions import AbstractExtension
from .library_integration_layer.config import AppConfig
from .library_integration_layer.logger import DirectoryLogger
from .library_integration_layer.flask_application import App
from .library_integration_layer.sql_vendor.instrumentation import SqlAlchemyInstrumenter


class ContextualLoggingExtension(AbstractExtension):
    def _setup_extension(self, app):
        from tools_structured_logs.logic.configuration.library import get_library
        logger = DirectoryLogger()
        app.tools_log_context_app = App(logger)
        get_library(
            config=AppConfig(),
            logger=logger,
            instrumented_app_hooks=app.tools_log_context_app,
            domain_models=[
                SessionObjectInstrumenter(app.requests),
            ]
        )
