# coding: utf-8

from tools_structured_logs.logic.configuration.config.interface import Config

from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.utils import is_debug_logging_enabled


class AppConfig(Config):
    @property
    def flask_config(self):
        return app.config['STRUCTURED_LOGS']

    def get_context_providers(self):
        return self.flask_config['context_providers']

    def get_enable_tracking(self):
        return self.flask_config['enable_tracking'] or is_debug_logging_enabled()

    def get_enable_db_tracking(self):
        return self.flask_config['db_tracking'] or is_debug_logging_enabled()

    def get_enable_http_tracking(self):
        return self.flask_config['http_tracking'] or is_debug_logging_enabled()

    def get_enable_stack_traces(self):
        return self.flask_config['enable_stacktraces']

    def get_http_response_max_size(self):
        return self.flask_config['http_response_max_size']

    def get_sql_warning_threshold(self):
        return self.flask_config['sql_warning_threshold']
