# coding: utf-8

from contextlib import contextmanager
from tools_structured_logs.helpers.flask.flask_application import FlaskApplication
from intranet.yandex_directory.src.yandex_directory.common.views.main import StatsView, PingView


class App(FlaskApplication):
    def do_log_vendor_info(self, view_instance):
        """
        @rtype: bool
        """
        return not isinstance(view_instance, (StatsView, PingView))

    @contextmanager
    def all_the_logs_for_http(self, request, threshold=0, **kwargs):
        if self.do_log_vendor_info(kwargs['endpoint']):
            with super(App, self).all_the_logs_for_http(request, threshold, **kwargs):
                yield
        else:
            yield  # do nothing
