# coding: utf-8

from flask import g
from tools_structured_logs.logic.common_log_fields.field_structure.auth import Provider as BaseProvider

from intranet.yandex_directory.src.yandex_directory.common.utils import (
    get_auth_fields_for_log,
)


class Provider(BaseProvider):

    def get_email(self, **ctx):
        return None

    def get_uid(self, **ctx):
        if not hasattr(g, 'user'):
            return None
        if not g.user:
            return None
        return str(g.user.passport_uid)

    def get_cloud_uid(self, **ctx):
        if not hasattr(g, 'user'):
            return None
        if not g.user:
            return None
        if not g.user.is_cloud:
            return None
        return str(g.user.cloud_uid)

    def get_application(self, **ctx):
        if not hasattr(g, 'service'):
            return None
        if not g.service:
            return None
        return g.service.identity

    def get_auth_mechanism(self, **ctx):
        if not hasattr(g, 'auth_type'):
            return None
        return g.auth_type

    def field_user(self, **ctx):
        result = super(Provider, self).field_user(**ctx)
        user_fields = get_auth_fields_for_log(g).get('user')
        if user_fields is not None:
            result.update(
                ip=user_fields['ip'],
                karma=user_fields['karma']
            )
        return result

    def field_service(self, **ctx):
        fields = get_auth_fields_for_log(g).get('service')
        if fields is not None:
            return dict(
                ip=fields['ip'],
                internal=fields['internal'],
            )
        return None
