# coding: utf-8

from flask import g

from tools_structured_logs.logic.common_log_fields.field_structure.request import Provider as BaseProvider


class Provider(BaseProvider):
    required_kwargs = ['request']

    def get_request_id(self, **ctx):
        return g.request_id

    def get_request_path(self, request, **ctx):
        return request.path

    def get_query_params(self, request, **ctx):
        return request.args.to_dict()

    def get_http_method(self, request, **ctx):
        return request.method
