# coding: utf-8

import math
import time
from warnings import warn
from tools_structured_logs.logic.log_records.vendors.sql.info_provider import Cursor


class SqlRequestExecutedProvider(Cursor):
    context_requires = [
        'connection',
        'prepared_statement',
        'final_statement',
    ]

    def query_connection_encoding(self):
        return 'will never be available'

    def query_transaction_isolation_level(self):
        return self._context['connection'].get_isolation_level()

    def query_transaction_status(self):
        return 1 if self._context['connection'].in_transaction() else 0

    def query_final_sql(self):
        return self._context['final_statement'].strip()

    def query_prepared_sql(self):
        return self._context['prepared_statement'].strip()

    def duration(self):
        # перенести вывод округленных в библиотеку
        return max(
                time.time() - self._context['connection'].info['query_start_time'][-1],
                0
            ) * 1000

    def vendor(self):
        return 'sqlalchemy'
