# coding: utf-8

from tools_structured_logs.logic.log_records.vendors.base_vendor import IVendorInstrumenter
from .after_sql_executed_provider import SqlRequestExecutedProvider
from sqlalchemy import event
from sqlalchemy.engine import Engine
from sqlalchemy.sql.compiler import Compiled


class SqlAlchemyInstrumenter(IVendorInstrumenter):
    def structured_logs(self, conn, clauseelement, multiparams, params, result):
        """
        Записать в логи SQL Alchemy запрос.

        Сейчас точно есть проблемы что в final и в prepared попадает все что попало.
        Когда весь код будет использовать алхимию в поля логов будут гарантированно попадать:
          * в final -  итоговый SQL передаваемый в базу
          * в prepared -  исходных SQL без подставлленых параметров
        """
        if isinstance(clauseelement, str):
            statement = clauseelement
        elif isinstance(clauseelement, Compiled):
            statement = getattr(clauseelement.statement)
        else:
            statement = 'unknown, got "{}"'.format(type(clauseelement))

        SqlRequestExecutedProvider().set_context(
            connection=conn,
            final_statement=str(clauseelement),
            prepared_statement=statement,
        ).make_records()

    def instrument(self):
        event.listen(Engine, "after_execute", self.structured_logs)
