# coding: utf-8

from intranet.yandex_directory.src.yandex_directory.core.utils import (
    is_yandex_team_uid,
    is_outer_uid,
    is_cloud_uid,
)


def activate_user(main_connection, org_id, obj, *args, **kwargs):
    from . import ActivateUserDiskTask
    uid = obj['id']
    # skip for yandex-team, portal accounts, robots
    if not is_yandex_team_uid(uid) and not is_outer_uid(uid) and not is_cloud_uid(uid) and obj['user_type'] != 'robot':
        ActivateUserDiskTask(main_connection).delay(
            org_id=org_id,
            uid=uid,
        )
