# encoding: UTF-8

from intranet.yandex_directory.src.yandex_directory.common.components import component_registry
from intranet.yandex_directory.src.yandex_directory.common.extensions import AbstractExtension
from intranet.yandex_directory.src.yandex_directory.limits.components import DefaultOrganizationLimiter
from intranet.yandex_directory.src.yandex_directory.limits.views import org_limits_bp


class OrganizationLimitsComponentsConfig(AbstractExtension):
    """
    Расширение настраивающее компоненты реализующие бизнес-логику лимитов
    организации.
    """

    def _setup_extension(self, app):
        app.register_blueprint(org_limits_bp)

        components = component_registry(app)
        components.organization_limiter = DefaultOrganizationLimiter(
            repository=components.meta_organization_repository,
            defaults=app.config['ORG_LIMITS'],
        )
