# encoding: UTF-8

from marshmallow import post_load
from marshmallow import pre_dump
from marshmallow import Schema
from marshmallow.fields import Integer
from marshmallow.fields import String

from intranet.yandex_directory.src.yandex_directory.common.marshmallow import Enum
from intranet.yandex_directory.src.yandex_directory.common.marshmallow import TypedDict
from intranet.yandex_directory.src.yandex_directory.limits.models import OrganizationLimit


class LimitsSchema(Schema):
    """
    Схема представления лимитов организации.
    """

    limits = TypedDict(
        Integer(allow_none=True),
        key_field=Enum(OrganizationLimit),
        required=True,
    )

    @pre_dump
    def do_wrap(self, data, **kwargs):
        return {'limits': data}

    @post_load
    def do_unwrap(self, data, **kwargs):
        return data['limits']


class UpdateLimitsSchema(Schema):
    """
    Схема парсинга лимитов организации.
    """

    limits = TypedDict(
        Integer(allow_none=True),
        key_field=Enum(OrganizationLimit),
        required=True,
    )


class UpdateLimitsAdminSchema(Schema):
    """
    Схема парсинга лимитов организации.
    """

    limits = TypedDict(
        Integer(allow_none=True),
        key_field=Enum(OrganizationLimit),
        required=True,
    )
    comment = String(required=True)
