# encoding: UTF-8

from flask import has_request_context
from flask import request
from sqlalchemy.orm import Session

from intranet.yandex_directory.src.yandex_directory.common.appcontext import appcontext_cached
from intranet.yandex_directory.src.yandex_directory.common.components import component_registry
from intranet.yandex_directory.src.yandex_directory.common.db import _select_engine
from intranet.yandex_directory.src.yandex_directory.common.db import closing
from intranet.yandex_directory.src.yandex_directory.common.web import is_method_modifying


def create_main_session(shard_number, is_modifying=False):
    # type: (int, bool) -> Session
    """
    Фабрика main-сессий.
    """
    engine = _select_engine('main', shard_number, is_modifying)
    session = Session(engine)
    components = component_registry()
    components.exit_stack.enter_context(closing(session))
    components.exit_stack.enter_context(session.transaction)
    return session


@appcontext_cached('shard_number')
def get_main_session(shard_number, is_modifying=None):
    # type: (int, bool) -> Session
    """
    Контектсно-зависимая фабрика main-сессий. Main-сессия создается один раз
    в рамках запроса или контекстного менеджера ``app.app_context()``.
    """

    if is_modifying is None:
        if has_request_context():
            is_modifying = is_method_modifying(request.method)
        else:
            is_modifying = False

    return create_main_session(shard_number, is_modifying)
