# encoding: UTF-8

from functools import partial

from sqlalchemy.orm import Session
from typing import cast
from werkzeug.local import LocalProxy

from intranet.yandex_directory.src.yandex_directory.common.components import component_registry
from intranet.yandex_directory.src.yandex_directory.common.db import get_shard_numbers
from intranet.yandex_directory.src.yandex_directory.common.extensions import AbstractExtension
from intranet.yandex_directory.src.yandex_directory.main.components import get_main_session
from intranet.yandex_directory.src.yandex_directory.main.dao import DomainRepository
from intranet.yandex_directory.src.yandex_directory.main.dao import OrganizationRepository


class MainComponentsConfig(AbstractExtension):
    """
    Расширение настраивающее компоненты реализующие бизнес-логику main-объектов.
    """

    def _setup_extension(self, app):
        components = component_registry(app)
        components.main_sessions = dict()
        components.main_session_providers = dict()
        components.organization_repositories = dict()
        components.domain_repositories = dict()

        # Для каждого шарда создаем необходимые компоненты
        for shard_number in get_shard_numbers():
            components.main_sessions[shard_number] = \
                LocalProxy(partial(get_main_session, shard_number))

            components.main_session_providers[shard_number] = \
                lambda: cast(Session, components.main_sessions[shard_number])

            components.organization_repositories[shard_number] = \
                OrganizationRepository(
                    components.main_session_providers[shard_number],
                )

            components.domain_repositories[shard_number] = \
                DomainRepository(
                    components.main_session_providers[shard_number],
                )
