# encoding: UTF-8

from sqlalchemy import BigInteger
from sqlalchemy import Column
from sqlalchemy import ForeignKey
from sqlalchemy import String
from sqlalchemy.ext.declarative import as_declarative
from sqlalchemy.orm import relation

from intranet.yandex_directory.src.yandex_directory.common.sqlalchemy import ModelMeta


@as_declarative(metaclass=ModelMeta)
class MainModel(object):
    """
    Базовый класс для main-моделей с поддержкой ``abc``.
    """


class Organization(MainModel):
    """
    Модель организаций.
    """

    __tablename__ = 'organizations'

    id = Column(BigInteger, primary_key=True)
    admin_uid = Column(BigInteger)

    domains = relation(
        lambda: Domain,
        cascade='all,delete-orphan',
        uselist=True,
        back_populates='organization',
    )


class Domain(MainModel):
    """
    Модель доменов.
    """

    __tablename__ = 'domains'

    org_id = Column(ForeignKey(Organization.id), primary_key=True)
    name = Column(String, primary_key=True)
    registrar_id = Column(BigInteger)

    organization = relation(
        lambda: Organization,
        back_populates='domains',
    )
