# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.common.exceptions import APIError


class MDSError(APIError):
    code = 'mds.base_error'
    status_code = 400


class MDSUnavailableError(MDSError):
    status_code = 503
    code = 'mds.unavailable'
    message = 'Image uploading is unavailable right now'
    description = 'Загрузка изображений временно недоступна'


class MDSUnknownError(MDSError):
    code = 'mds.unknown_error'
    description = 'Неизвестная ошибка сервиса MDS.'


class MDSInvalidURLError(MDSError):
    code = 'mds.url_invalid'
    message = 'Incorrect URL format'
    description = 'Неверный URL.'


class MDSImageTooSmallError(MDSError):
    code = 'mds.image_too_small'
    message = 'Image is too small.'
    description = 'Размер картинки слишком мал.'


class MDSImageIsBlacklistedError(MDSError):
    code = 'mds.image_blacklisted'
    message = 'Image was found in the blacklist.'
    description = 'Картинка содержится в черном списке.'


def raise_mds_error(bad_response):
    """Берет из ответа MDS описание ошибки, и кидает исключение типа MDSError
    с определённым кодом.
    """
    description = bad_response.get('description')

    if description == 'Image is too small':
        raise MDSImageTooSmallError()

    if description == 'The image is found in blacklist':
        raise MDSImageIsBlacklistedError()

    if description in ('incorrect path', 'bad arity'):
        # Ошибка bad arity возникает в случае, когда количество
        # слэшей в path больше, чем необходимо.
        raise MDSInvalidURLError()

    raise MDSUnknownError()
