# encoding: UTF-8

from flask import has_request_context
from flask import request
from sqlalchemy.orm import Session

from intranet.yandex_directory.src.yandex_directory.common.appcontext import appcontext_cached
from intranet.yandex_directory.src.yandex_directory.common.components import component_registry
from intranet.yandex_directory.src.yandex_directory.common.db import _select_engine
from intranet.yandex_directory.src.yandex_directory.common.db import closing
from intranet.yandex_directory.src.yandex_directory.common.web import is_method_modifying


def create_meta_session(is_modifying=False):
    # type: (bool) -> Session
    """
    Фабрика мета-сессий.
    """
    engine = _select_engine('meta', 1, is_modifying)
    session = Session(engine)
    components = component_registry()
    components.exit_stack.enter_context(closing(session))
    components.exit_stack.enter_context(session.transaction)
    return session


@appcontext_cached
def get_meta_session(is_modifying=None):
    # type: (bool) -> Session
    """
    Контектсно-зависимая фабрика мета-сессий. Мета-сессия создается один раз
    в рамках запроса или контекстного менеджера ``app.app_context()``.
    """

    if is_modifying is None:
        if has_request_context():
            is_modifying = is_method_modifying(request.method)
        else:
            is_modifying = False

    return create_meta_session(is_modifying)
