# encoding: UTF-8

from sqlalchemy.orm import Session
from typing import cast
from werkzeug.local import LocalProxy

from intranet.yandex_directory.src.yandex_directory.common.components import component_registry
from intranet.yandex_directory.src.yandex_directory.common.extensions import AbstractExtension
from intranet.yandex_directory.src.yandex_directory.meta.components import get_meta_session
from intranet.yandex_directory.src.yandex_directory.meta.repositories import (
    MetaOrganizationRepository,
    MetaUserRepository,
    RegistrarRepository,
    DomainTokenRepository,
)
from intranet.yandex_directory.src.yandex_directory.meta.repositories.resource_history_repository import ResourceHistoryRepository


class MetaComponentsConfig(AbstractExtension):
    """
    Расширение настраивающее компоненты реализующие бизнес-логику мета-объектов.
    """

    def _setup_extension(self, app):
        components = component_registry(app)

        components.meta_session = \
            LocalProxy(get_meta_session)

        components.meta_session_provider = \
            lambda: cast(Session, components.meta_session)

        components.meta_organization_repository = \
            MetaOrganizationRepository(components.meta_session_provider)

        components.meta_users = \
            MetaUserRepository(components.meta_session_provider)

        components.registrar_repository = \
            RegistrarRepository(components.meta_session_provider)

        components.domain_token_repository = \
            DomainTokenRepository(components.meta_session_provider)

        components.resource_history_repository = \
            ResourceHistoryRepository(components.meta_session_provider)
