# coding: utf-8
from intranet.yandex_directory.src.yandex_directory.common.db import get_meta_connection
from intranet.yandex_directory.src.yandex_directory.core.models import ServiceModel
from intranet.yandex_directory.src.yandex_directory.meta.models.resource_history import ResourceHistory
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


def make_resource_history(
        service_slug,
        resource_id,
        name=None,
        org_id=None,
        action=None,
        author_id=None,
        comment=None,
        source='CONNECT',
):
    with get_meta_connection() as meta_connection:
        service = ServiceModel(meta_connection).get_by_slug(service_slug)
        if not service:
            log.error('Could not find service with slug "{}"'.format(service_slug))
            return
        service_id = service['id']

    return ResourceHistory(
        service_id=service_id,
        resource_id=resource_id,
        name=name,
        org_id=org_id,
        action=action,
        author_id=author_id,
        comment=comment,
        source=source,
    )


def make_domain_resource_history(
        resource_id,
        name=None,
        org_id=None,
        action=None,
        author_id=None,
        comment=None,
        source='CONNECT',
):
    return make_resource_history(
        'dominator',
        resource_id,
        name,
        org_id,
        action,
        author_id,
        comment,
        source,
    )
