# encoding: UTF-8


from sqlalchemy import BigInteger, ForeignKey
from sqlalchemy import Boolean
from sqlalchemy import Column
from sqlalchemy import Integer
from sqlalchemy import String
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql.json import JSONB
from sqlalchemy.ext.declarative import as_declarative

from intranet.yandex_directory.src.yandex_directory.common.sqlalchemy import ModelMeta
from intranet.yandex_directory.src.yandex_directory.common.sqlalchemy import MutableDict


@as_declarative(metaclass=ModelMeta)
class MetaModel(object):
    """
    Базовый класс для мета-моделей с поддержкой ``abc``.
    """
    @classmethod
    def create(cls, **kwargs):
        instance = cls()
        simple_columns = cls.__table__.columns
        for column, value in list(kwargs.items()):
            if column not in simple_columns:
                raise ValueError('Unknown column: {}'.format(column))
            setattr(instance, column, value)
        return instance


class MetaOrganization(MetaModel):
    """
    Модель мета-организаций.
    """

    __tablename__ = 'organizations'

    id = Column(BigInteger, primary_key=True)
    label = Column(String)
    shard = Column(Integer)
    ready = Column(Boolean)
    limits = Column(MutableDict.as_mutable(JSONB))


class MetaUser(MetaModel):
    __tablename__ = 'users'

    id = Column(BigInteger, primary_key=True)
    org_id = Column(BigInteger,
                    ForeignKey('MetaOrganization.id'),
                    primary_key=True)
    is_outer = Column(Boolean)
    user_type = Column(String)
    is_dismissed = Column(Boolean)
    # Это у меня почему-то не заработало, надо будет потом поразбираться
    # organization = relationship('MetaOrganization',
    #                             backref='users',
    #                             primaryjoin='MetaUser.org_id == MetaOrganization.id')
#                                foreign_keys='MetaUser.org_id')


class Registrar(MetaModel):
    """
    Модель регистраторов
    """

    __tablename__ = 'registrars'

    id = Column(BigInteger, primary_key=True)

    pdd_id = Column(BigInteger)
    pdd_version = Column(String)
    name = Column(String)
    admin_id = Column(BigInteger)
    password = Column(String)
    oauth_client_id = Column(String)
    # Соответствует payed_url из старого API ПДД
    validate_domain_url = Column(String)
    # Соответствует added_init
    domain_added_callback_url = Column(String)
    # Соответствует added
    domain_verified_callback_url = Column(String)
    # Соответствует delete_url
    domain_deleted_callback_url = Column(String)
    # токен регистратора - применимо только для новых регистраторов
    token = Column(String)
    # соль для паролей - применимо только для новых регистраторов
    iv = Column(String)
    # длина пароля новых - применимо только для новых регистраторов
    plength = Column(Integer)


class DomainToken(MetaModel):
    """
    Модель токенов доменов
    """

    __tablename__ = 'domain_tokens'

    id = Column(BigInteger, primary_key=True)

    pdd_version = Column(String)
    admin_id = Column(BigInteger)
    domain = Column(String)
    token = Column(String)
