# coding: utf-8
import datetime

from sqlalchemy import Column, Integer, String, DateTime, BigInteger, ForeignKey
from sqlalchemy.orm import relationship

from intranet.yandex_directory.src.yandex_directory.meta.models.service import Service
from . import MetaModel


class ResourceHistory(MetaModel):
    __tablename__ = 'resource_history'

    id = Column(BigInteger, primary_key=True)

    service_id = Column(Integer, ForeignKey('services.id'))
    resource_id = Column(String)
    name = Column(String)
    org_id = Column(Integer)
    action = Column(String)
    author_id = Column(Integer)
    timestamp = Column(DateTime, default=datetime.datetime.utcnow)
    comment = Column(String)
    source = Column(String)

    service = relationship(Service)
