# coding: utf-8
from requests import Session
from sqlalchemy import desc

from intranet.yandex_directory.src.yandex_directory.common.sqlalchemy import CRUDRepository
from intranet.yandex_directory.src.yandex_directory.common.utils import NotGiven
from intranet.yandex_directory.src.yandex_directory.meta.models.resource_history import ResourceHistory
from intranet.yandex_directory.src.yandex_directory.meta.models.service import Service


class ResourceHistoryRepository(CRUDRepository):
    def __init__(self, session_provider):
        super(ResourceHistoryRepository, self).__init__(
            ResourceHistory,
            session_provider,
        )

    def find_by_fields(self, fields, limit=None, offset=None, session=None):
        # type: (dict, int, int, Session) -> list
        query = self._query(session)

        resource_id = fields.get('resource_id')
        if resource_id is not NotGiven:
            query = query.filter(ResourceHistory.resource_id == resource_id)

        name = fields.get('name')
        if name is not NotGiven:
            query = query.filter(ResourceHistory.name == name)

        service_slug = fields.get('service_slug')
        if service_slug is not NotGiven:
            query = query.join(Service).\
                filter(Service.slug == service_slug)

        query = query.order_by(desc(ResourceHistory.id))

        if offset:
            query = query.offset(offset)

        if limit:
            query = query.limit(limit)

        return query.all()
