# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.utils import (
    call_passport_if_needed,
    is_yandex_team_uid,
    is_outer_uid,
)
from intranet.yandex_directory.src.yandex_directory.passport import (
    exceptions,
)
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.utils import make_simple_strings


@call_passport_if_needed
def edit_passport_account(connection, event, obj, content, revision, org_id):
    if not obj.get('nickname'):
        return

    # Если пользователя патчили с целью заблокировать или разблокировать,
    # то не будем пытаться обновить его данные в паспорте, так как
    # это может привести к ошибке AccountDisabled, описанной тут:
    #
    # https://st.yandex-team.ru/TOOLSB-288
    if content['diff'].get('is_enabled'):
        return

    uid = obj['id']

    if is_yandex_team_uid(uid) or is_outer_uid(uid):
        # Не пытаемся изменять тимные или портальные; аккаунты, потому что это невозможно:
        # https://st.yandex-team.ru/DIR-6911
        return

    # Не пытаемся изменить SSO юзеров
    if obj.get('is_sso'):
        return

    obj = make_simple_strings(obj)

    user_data = {
        # TODO: подумать подробнее про локализацию.
        # В этом месте нужно проставлять имя по языку, указанному по дефолту
        'uid': uid,
        'firstname': obj['name']['first'],
        # Фамилия может быть не всегда
        'lastname': obj['name'].get('last') or '',
        # Если день рождения не указан, то паспорт ожидает получить пустую строку,
        # а None просто игнорирует.
        'birthday': obj['birthday'] or '',
        'gender': obj['gender'],
    }

    with log.fields(org_id=org_id, nickname=obj['nickname'], operation='edit-passport-account'):
        try:
            app.passport.account_edit(user_data)
        except exceptions.PassportException:
            log.trace().warning('Unable edit account')
