# coding: utf-8

from intranet.yandex_directory.src.yandex_directory.common.web import ErrorResponseBuilder
from intranet.yandex_directory.src.yandex_directory.common.web import ResponseMixin


class ZoraError(Exception, ResponseMixin):
    """
    Ошибка при работе с Zora
    """
    status_code = 503
    code = 'zora_error'

    def __init__(self):
        super(ZoraError, self).__init__('Zora error acquired')

    def as_response(self, i18n_localizer):
        return ErrorResponseBuilder(self.status_code, self.code).build(i18n_localizer)


class ZoraInternalCodeError(ZoraError):
    code = 'zora_internal_code_error'

    def __init__(self, zora_code):
        super(ZoraInternalCodeError, self).__init__()
        self.zora_code = zora_code

    def as_response(self, i18n_localizer):
        return ErrorResponseBuilder(self.status_code, self.code)\
            .set_parameter('zora_code', self.zora_code)\
            .build(i18n_localizer)


class ZoraInvalidCodeError(ZoraInternalCodeError):
    pass





