from django.contrib import admin
from intranet.yasanta.backend.gifts.models import Event, SantaEntry, GiftType, Report


class GiftTypeInline(admin.TabularInline):
    model = GiftType


class EventAdmin(admin.ModelAdmin):
    inlines = [
        GiftTypeInline,
    ]
    list_display = ('name',)


class SantaEntryAdmin(admin.ModelAdmin):
    list_display = ('get_event_name', 'lucky_login', 'collected_count',)
    readonly_fields = ('get_event_name',)
    fields = (
        'get_event_name',
        'lucky_login',
        'himself',
        'collector_login',
        'collected_time',
        'collected_count',
        'instruction',
    )

    def get_event_name(self, obj):
        return obj.event.name
    get_event_name.short_description = 'Событие'


class ReportAdmin(admin.ModelAdmin):
    list_display = ('get_entry_event', 'get_entry_login', 'time', 'action', 'count',)
    readonly_fields = ('get_entry_event', 'get_entry_login',)
    fields = (
        'get_entry_event',
        'get_entry_login',
        'time',
        'action',
        'count',
    )

    def get_entry_login(self, obj):
        return obj.entry.lucky_login
    get_entry_login.short_description = 'Логин сотрудника'

    def get_entry_event(self, obj):
        return obj.entry.event.name
    get_entry_event.short_description = 'Событие'


admin.site.register(Event, EventAdmin)
admin.site.register(SantaEntry, SantaEntryAdmin)
admin.site.register(Report, ReportAdmin)
