# encoding: utf-8
from __future__ import unicode_literals

import re

import sform

from intranet.yasanta.backend.gifts.models import GiftType


sub_re = re.compile(r'[\s,;\'\"]+')


class SantaEntryForm(sform.SForm):
    himself = sform.BooleanField(default=False)
    filter_url = sform.CharField()

    def get_field_state(self, name):
        if name == 'himself' and self.initial.get('collected_count') > 0:
            return sform.READONLY
        return super(SantaEntryForm, self).get_field_state(name)

    def clean_filter_url(self, filter_url):
        filter_url = sub_re.sub(' ', filter_url).lower().strip()
        return sorted(set(filter_url.split()))


class CollectForm(sform.SForm):

    def __init__(self, *args, **kwargs):
        super(CollectForm, self).__init__(*args, **kwargs)
        event = self.initial['event']
        self.gifts_types = {g.id: g for g in GiftType.objects.filter(event=event)}

    count = sform.IntegerField(default=1)
    gift_type = sform.IntegerField()

    def get_field_state(self, name):
        if name == 'gift_type' and self.gifts_types:
            return sform.REQUIRED
        return super(CollectForm, self).get_field_state(name)

    def clean_gift_type(self, gift_type_id):
        gift_type = self.gifts_types.get(gift_type_id)
        if self.gifts_types and not gift_type:
            raise sform.ValidationError('Gift type is required', code='required')
        return gift_type
