import datetime

from django.core.management.base import BaseCommand

from intranet.yasanta.backend.gifts.management.commands.common import add_entries_by_staff_api_query


def get_query():
    date = (datetime.datetime.utcnow() - datetime.timedelta(weeks=1)).strftime('%Y-%m-%d')
    query = ' and '.join([
        'official.join_at>="{}"',
        'official.is_trainee==true',
        'official.is_dismissed==False',
    ]).format(date)
    return query


class Command(BaseCommand):
    def handle(self, *args, **options):
        add_entries_by_staff_api_query(
            event_code='TeeShirtIntern',
            query=get_query(),
        )
