import datetime

from django.core.management.base import BaseCommand

from intranet.yasanta.backend.gifts.management.commands.common import add_entries_by_staff_api_query


def get_query():
    return (
        'official.join_at>="{date}" '
        'and official.is_dismissed==false '
        'and (department_group.ancestors.department.url=="{department_url}" '
        'or department_group.department.url=="{department_url}")'
    ).format(
        date=(datetime.datetime.utcnow() - datetime.timedelta(weeks=1)).strftime('%Y-%m-%d'),
        department_url='yandex_monetize_market',
    )


class Command(BaseCommand):
    def handle(self, *args, **options):
        add_entries_by_staff_api_query(
            event_code='market_welcome_pack',
            query=get_query(),
        )
