import datetime

from django.core.management.base import BaseCommand

from intranet.yasanta.backend.gifts.management.commands.common import add_entries_by_staff_api_query


def get_query():
    start_date = datetime.date(year=2018, month=9, day=20)
    month_ago = datetime.date.today() - datetime.timedelta(days=32)

    query = ' and '.join([
        'official.join_at>="{start_date}"',
        'official.join_at<="{month_ago}"',
        'official.is_trainee==false',
        'official.is_dismissed==False',
        'official.affiliation=="yandex"',
    ]).format(start_date=start_date, month_ago=month_ago)
    return query


class Command(BaseCommand):
    def handle(self, *args, **options):
        add_entries_by_staff_api_query(
            event_code='newbie-t-shirt',
            query=get_query(),
        )
