from django.core.management.base import CommandError

from intranet.yasanta.backend.tools import get_people, StaffApiError

from intranet.yasanta.backend.gifts.controller import get_event
from intranet.yasanta.backend.gifts.models import SantaEntry


def add_entries_by_staff_api_query(event_code, query):
    event = get_event(event_code=event_code)
    if event is None:
        raise CommandError('Unknown event: {}'.format(event_code))

    try:
        people = get_people(query)
    except StaffApiError:
        raise CommandError('Error when retrieve people from staffapi')

    people_in_db = (
        SantaEntry.objects
        .filter(lucky_login__in=people, event=event)
        .values_list('lucky_login', flat=True)
    )
    people_to_create = list(set(people) - set(people_in_db))

    try:
        SantaEntry.objects.bulk_create([
            SantaEntry(
                event=event,
                lucky_login=p,
                collector_login=p,
            )
            for p in people_to_create
        ])
    except Exception:
        raise CommandError('Error when creating entries for event %s' % event_code)
