# Generated by Django 2.1 on 2018-08-16 09:44

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=32, unique=True, verbose_name='Текстовый идентификатор')),
                ('name', models.CharField(max_length=256, verbose_name='Название события')),
                ('comment', models.CharField(max_length=256, verbose_name='Комментарий')),
                ('admins', models.CharField(max_length=1024, verbose_name='Логины админов')),
            ],
            options={
                'db_table': 'yasanta_event',
            },
        ),
        migrations.CreateModel(
            name='SantaEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lucky_login', models.CharField(max_length=256, verbose_name='Логин сотрудника')),
                ('himself', models.BooleanField(default=False, verbose_name='Сотрудник сам заберет подарок')),
                ('collector_login', models.CharField(db_index=True, max_length=256, verbose_name='Логин забравшего сотрудника')),
                ('collected', models.BooleanField(default=False, verbose_name='Подарок забран')),
                ('collected_time', models.DateTimeField(blank=True, null=True, verbose_name='Момент, когда забрали')),
                ('filter_url', models.TextField(blank=True, default='', verbose_name='Список логинов, для кого хочется забрать')),
                ('instruction', models.CharField(default='', max_length=256, verbose_name='Инструкция к подарку')),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gifts.Event', verbose_name='Событие')),
            ],
            options={
                'db_table': 'yasanta_santaentry',
            },
        ),
        migrations.AlterUniqueTogether(
            name='santaentry',
            unique_together={('event', 'lucky_login')},
        ),
    ]
