# Generated by Django 2.1 on 2018-08-20 15:14

from django.db import migrations, models
from django.db.models.functions import Cast


def migrate_collected_field(apps, schema_editor):
    SantaEntry = apps.get_model('gifts', 'SantaEntry')
    (
        SantaEntry.objects
        .update(
            collected_count=Cast(models.F('collected'), models.IntegerField())
        )
    )


class Migration(migrations.Migration):

    dependencies = [
        ('gifts', '0002_gifttype'),
    ]

    operations = [
        migrations.AddField(
            model_name='santaentry',
            name='collected_count',
            field=models.IntegerField(default=0, verbose_name='Количество, которое забрал'),
        ),
        migrations.RunPython(migrate_collected_field),
    ]
