# encoding: utf-8
from __future__ import unicode_literals

import requests
import logging

from django.conf import settings


logger = logging.getLogger(__name__)


class KeyNotFound(Exception):
    pass


def get_key_owner(key):
    try:
        key = (int(str(key), 16) & 0x7fffffff) % 1000000000
    except ValueError:
        raise KeyNotFound

    url = '%s/rfid-api/export/%s/' % (settings.STAFF_HOST, key)

    result = requests.get(
        url,
        timeout=3,
        allow_redirects=False,
        headers={'Authorization': 'OAuth %s' % settings.OAUTH_TOKEN}
    )

    if result.status_code == 404:
        raise KeyNotFound

    if result.status_code >= 300:
        logger.info(
            'Staff key export respond: status=%s, content=%s',
            result.status_code,
            result.content,
        )
        raise Exception

    result = result.json()

    return result
