import requests
import logging

from django.conf import settings

logger = logging.getLogger(__name__)


class StaffApiError(Exception):
    pass


def get_people(query):
    url = '{}/v3/persons'.format(settings.STAFF_API_HOST)
    params = {
        '_limit': 1000,
        '_fields': 'official.is_trainee,official.join_at,login',
        '_page': 0,
        '_query': query,
    }
    pages = 1
    people = []
    while params['_page'] < pages:
        params['_page'] += 1
        try:
            result = requests.get(
                url,
                params,
                timeout=10,
                headers={'Authorization': f'OAuth {settings.OAUTH_TOKEN}'},
            )
            if result.status_code not in [200, 400]:
                raise Exception
        except Exception:
            logger.info(
                'Staff api is not working. Url: %s, params %s',
                url,
                params,
            )
            raise StaffApiError

        try:
            result_json = result.json()
        except Exception:
            logger.info('Result is not a json')
            raise StaffApiError

        try:
            pages = result_json['pages']
            params['_page'] = result_json['page']
            for person in result_json['result']:
                people.append(person['login'])
        except Exception:
            logger.info(
                'Staff api error: %s by %s',
                result_json.get('error_message', 'no error message'),
                result.url,
            )
            raise StaffApiError

    return people
