from django.urls import path, register_converter
from intranet.yasanta.backend.gifts import views

from django.http import HttpResponseRedirect

from django.contrib import admin


def redirect(url_path):
    def redirect_view(*args, **kwargs):
        return HttpResponseRedirect(url_path)
    return redirect_view


class LoginConverter:
    regex = r'\*?[\w\-.]+'

    @staticmethod
    def to_python(value):
        return str(value)

    @staticmethod
    def to_url(value):
        return '%04d' % value


register_converter(LoginConverter, 'login')


urlpatterns = [
    path('', redirect('https://forms.yandex-team.ru/surveys/12599/'), name='index'),
    path('distribution/', redirect('/NewYear2017/distribution/'), name='distribution'),
    path('<slug:event_code>/auth/', views.auth),
    path('<slug:event_code>/prepare/', views.prepare),
    path('<slug:event_code>/prepare/<login:person_login>/', views.prepare),
    path('<slug:event_code>/collect/<login:person_login>/', views.collect),

    path('api/<slug:event_code>/auth/', views.auth),
    path('api/<slug:event_code>/prepare/', views.prepare),
    path('api/<slug:event_code>/prepare/<login:person_login>/', views.prepare),
    path('api/<slug:event_code>/collect/<login:person_login>/', views.collect),
    path('api/<slug:event_code>/return/<login:person_login>/', views.collect_back),
    path('api/<slug:event_code>/report/', views.report),
    path('api/<slug:event_code>/export_excel/', views.export_excel),
    path('api/<slug:event_code>/info/', views.info),
    path('admin/', admin.site.urls),
]
