/**
 * Раскрывает require, используя browserify.
 */
var browserify = require('browserify');

module.exports = require('enb/lib/build-flow').create()
    .name('browserify')
    .target('target', '?.browser.js')
    .useFileList(['js'])
    .defineOption('opts', {})
    .defineOption('plugins', [])
    .defineOption('transforms', [])
    .builder(function(sources) {
        var b = browserify(this._opts);

        this._plugins.forEach(function(plugin) {
            b.plugin(plugin);
        });

        this._transforms.forEach(function(transform) {
            b.transform(transform);
        });

        return new Promise(function(resolve, reject) {
            b.add(sources.map(function(source) {
                return source.fullname;
            })).bundle(function(err, data) {
                if (err) {
                    return reject(err);
                }
                resolve(data);
            });
        });
    })
    .createTech();
