module.exports = {
    'env': {
        'browser': true,
        'commonjs': true,
        'es6': true,
        'node': true
    },
    'extends': 'eslint:recommended',
    'rules': {
        'indent': ['error', 4, {
            SwitchCase: 1
        }],
        'linebreak-style': ['error', 'unix'],
        'quotes': [ 'error', 'single'],
        'semi': ['error', 'always'],
        'complexity': ['warn', {
            max: 10
        }],
        'array-bracket-spacing': ['error', 'never'],
        'brace-style': 'error',
        'comma-dangle': ['error', 'never'],
        'comma-spacing': ['error', {
            before: false,
            after: true
        }],
        'comma-style': ['error', 'last'],
        'require-jsdoc': 'warn',
        'eol-last': 'error',
        'key-spacing': ['error', {
            beforeColon: false,
            afterColon: true,
            mode: 'strict'
        }],
        'no-multiple-empty-lines': ['error', {
            max: 1
        }],
        'no-trailing-spaces': 'error',
        'object-curly-spacing': ['error', 'never'],
        'one-var': ['error', 'never'],
        'semi-spacing': ['error', {
            before: false,
            after: true
        }]
    },
    'globals': {
        'moment': true,
        '_': true,
        'apply': true,
        'oninit': true,
        'block': true,
        'elem': true,
        'mod': true,
        'elemMod': true,
        'mode': true,
        'replace': true,
        'tag': true,
        'match': true,
        'def': true,
        'content': true,
        'js': true,
        'attrs': true,
        'mix': true,
        'applyCtx': true,
        'applyNext': true,
        'BEM': true,
        'BEMHTML': true,
        '$': true,
        'jQuery': true,
        'confirm': true
    }
};
