'use strict';

/**
 * Страница
 * @module distribution-page
 * @extends i-bem__dom
 * @author annvas
 */
BEM.DOM.decl('distribution-page', {
    onSetMod: {
        js: function() {
            var pathnameSplitted = location.pathname.split('/').filter(Boolean);
            // Костыль: забирать айди события для запроса независимо от роутинга на бэке
            this._eventId = pathnameSplitted[0] === 'distribution' ? pathnameSplitted[1] : pathnameSplitted[0];

            this._getInfo()
                .then(function(response) {
                    this._eventData = response;

                    BEM.DOM.update(this.elem('content'), BEMHTML.apply({
                        block: this.constructor.getName(),
                        elem: 'content',
                        tag: false,
                        eventData: this._eventData
                    }));

                    this._updateControls();
                })
                .catch(function(error) {
                    BEM.DOM.update(this.elem('content'), 'Не удалось загрузить данные о раздаче');
                    console.error(error);
                });
        }
    },
    _getInfo: function() {
        return this.request({
            url: '/api/' + this._eventId + '/info/'
        });
    },
    _updateControls: function() {
        const queryParams = new URLSearchParams(window.location.search);
        const $controls = this.findElem('controls');
        const html = BEMHTML.apply({
            block: this.__self.getName(),
            elem: 'controls',
            data: {
                from: queryParams.get('from') || ''
            }
        });

        BEM.DOM.replace($controls, html);
    }
});
