block('distribution').elem('buttons')(
    match(function() {
        return this._availableCount > 0;
    }).content()(function() {
        return [
            apply('button', {
                _buttonType: 'collect',
                _buttonText: 'Отдать'}
            ),
            apply('return_button')
        ];
    }),
    match(function() {
        return this._availableCount === 0;
    }).content()(function() {
        return apply('return_button');
    }),
    match(function() {
        return this._eventData.returnable && (this._collectorData.collected_count > 0);
    })(
        mode('return_button')(function() {
            return apply('button', {
                _buttonType: 'return',
                _buttonText: 'Получить обратно'
            });
        })
    ),
    match(function() {
        return !_.isEmpty(this._collectorData);
    })(
        mode('button')(function() {
            var pathnameSplitted = location.pathname.split('/').filter(Boolean);
            // Костыль: забирать айди события для запроса независимо от роутинга на бэке
            var eventId = pathnameSplitted[0] === 'distribution' ? pathnameSplitted[1] : pathnameSplitted[0];

            return {
                block: 's-form',
                mix: {
                    block: this.block,
                    elem: 'form'
                },
                js: true,
                url: '/api/' + eventId + '/'+ this._buttonType +'/' + this._collectorData.lucky_login + '/',
                content: [
                    apply('gift_type_field', {
                        _itemId: this._itemId
                    }),
                    apply('count_field'),
                    {
                        elem: 'button',
                        elemMods: {
                            type: 'submit'
                        },
                        buttonMods: {
                            type: 'submit',
                            size: 'm',
                            theme: 'normal'
                        },
                        content: this._buttonText
                    }
                ]
            };
        }),
        match(function() {
            return this._itemId;
        }).mode('gift_type_field')(function() {
            return {
                block: 's-field',
                elem: 'hidden',
                name: 'gift_type',
                value: this._itemId
            };
        }),
        match(function() {
            return this._buttonType === 'collect';
        }).mode('count_field')(function() {
            return {
                block: 's-field',
                elem: 'hidden',
                name: 'count',
                value: '1'
            };
        }),
        match(function() {
            return _.isArray(this._eventData.gift_types) &&
                !_.isEmpty(this._eventData.gift_types) &&
                this._availableCount > 0;
        }).content()(function() {
            return this._eventData.gift_types.map(function(item) {
                return apply('button', {
                    _buttonText: item.name,
                    _buttonType: 'collect',
                    _itemId: item.id
                });
            }).concat(apply('return_button'));
        })
    )
);
